// Copyright 1994 by Jon Dart.  All Rights Reserved.

#include "stdafx.h"
#include "rmove.h" 
#ifdef __BORLANDC__
#include <memory.h>
#endif

ReversibleMove::ReversibleMove()
: ExtendedMove()
{
  // These fields have no meaning for the default constructor, but
  // initialize them to something legal anyway.
  old_castlestatus[White] = old_castlestatus[Black] = Board::CanCastleEitherSide;
  old_enpassantsq[White] = old_enpassantsq[Black] = 0;
}

ReversibleMove::ReversibleMove( const Board &ABoard, const Square start,
  const Square dest, const Piece::PieceType p )
: ExtendedMove( ABoard, start, dest, p )
{
   old_hashcode = ABoard.HashCode();
   old_castlestatus[White] = ABoard.CastleStatus(White);
   old_castlestatus[Black] = ABoard.CastleStatus(Black);
   old_enpassantsq[White] = ABoard.EnPassantSq(White);
   old_enpassantsq[Black] = ABoard.EnPassantSq(Black);
}

ReversibleMove::ReversibleMove( const Board &ABoard,
 const ExtendedMove &emove) :
ExtendedMove( ABoard, emove )
{
   old_hashcode = ABoard.HashCode();
   old_castlestatus[White] = ABoard.CastleStatus(White);
   old_castlestatus[Black] = ABoard.CastleStatus(Black);
   old_enpassantsq[White] = ABoard.EnPassantSq(White);
   old_enpassantsq[Black] = ABoard.EnPassantSq(Black);
}
